IF OBJECT_ID('UFD_BUSCA_CONTA_PG_FORN') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_BUSCA_CONTA_PG_FORN
	END
	
GO	

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE   FUNCTION [dbo].[UFD_BUSCA_CONTA_PG_FORN](@CD_EMP 		INT, 
												  @CD_FORN 		INT)
RETURNS @RS_RETURN TABLE(		
		CD_CTB_CNT					VARCHAR(50),
		CD_CTB_CNT_RED				INT,
		RZ_FORN						VARCHAR(200))
		
	BEGIN

		INSERT INTO @RS_RETURN
			SELECT 			    
			    ISNULL(PG_FORN_CNT_CTB.CD_CTB_CNT,''), 
				ISNULL(PG_FORN_CNT_CTB.CD_CTB_CNT_RED,0), 
			    PG_FORN.RZ_FORN     
		    FROM 
				PG_FORN 
				LEFT OUTER JOIN PG_FORN_CNT_CTB ON 
				    PG_FORN.CD_EMP = PG_FORN_CNT_CTB.CD_EMP AND 
				    PG_FORN.CD_FORN = PG_FORN_CNT_CTB.CD_FORN    
		    WHERE 
				PG_FORN.CD_EMP 		= @CD_EMP
				AND PG_FORN.CD_FORN = @CD_FORN
		
		RETURN
	END		
	
GO


